function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import { DEFAULT_CONFIG } from '../core/config';
import { MATRIX_OPTIONS, NUMBER_OPTIONS } from '../core/function/config'; // create a read-only version of config

export var config = /* #__PURE__ */function config(options) {
  if (options) {
    throw new Error('The global config is readonly. \n' + 'Please create a mathjs instance if you want to change the default configuration. \n' + 'Example:\n' + '\n' + '  import { create, all } from \'mathjs\';\n' + '  const mathjs = create(all);\n' + '  mathjs.config({ number: \'BigNumber\' });\n');
  }

  return Object.freeze(DEFAULT_CONFIG);
};

_extends(config, DEFAULT_CONFIG, {
  MATRIX_OPTIONS: MATRIX_OPTIONS,
  NUMBER_OPTIONS: NUMBER_OPTIONS
});