<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function intersect

Calculates the point of intersection of two lines in two or three dimensions
and of a line and a plane in three dimensions. The inputs are in the form of
arrays or 1 dimensional matrices. The line intersection functions return null
if the lines do not meet.

Note: Fill the plane coefficients as `x + y + z = c` and not as `x + y + z + c = 0`.


## Syntax

```js
math.intersect(endPoint1Line1, endPoint2Line1, endPoint1Line2, endPoint2Line2)
math.intersect(endPoint1, endPoint2, planeCoefficients)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`w` | Array &#124; Matrix | Co-ordinates of first end-point of first line
`x` | Array &#124; Matrix | Co-ordinates of second end-point of first line
`y` | Array &#124; Matrix | Co-ordinates of first end-point of second line OR Co-efficients of the plane's equation
`z` | Array &#124; Matrix | Co-ordinates of second end-point of second line OR null if the calculation is for line and plane

### Returns

Type | Description
---- | -----------
Array | Returns the point of intersection of lines/lines-planes


## Examples

```js
math.intersect([0, 0], [10, 10], [10, 0], [0, 10])              // Returns [5, 5]
math.intersect([0, 0, 0], [10, 10, 0], [10, 0, 0], [0, 10, 0])  // Returns [5, 5, 0]
math.intersect([1, 0, 1],  [4, -2, 2], [1, 1, 1, 6])            // Returns [7, -4, 3]
```


