<!-- Note: This file is automatically generated from source code comments. Changes made in this file will be overridden. -->

# Function eigs

Compute eigenvalue and eigenvector of a real symmetric matrix.
Only applicable to two dimensional symmetric matrices. Uses Jacobi
Algorithm. Matrix containing mixed type ('number', 'bignumber', 'fraction')
of elements are not supported. Input matrix or 2D array should contain all elements
of either 'number', 'bignumber' or 'fraction' type. For 'number' and 'fraction', the
eigenvalues are of 'number' type. For 'bignumber' the eigenvalues are of ''bignumber' type.
Eigenvectors are always of 'number' type.


## Syntax

```js
math.eigs(x)
```

### Parameters

Parameter | Type | Description
--------- | ---- | -----------
`x` | Array &#124; Matrix | Matrix to be diagonalized

### Returns

Type | Description
---- | -----------
{values: Array, vectors: Array} &#124; {values: Matrix, vectors: Matrix} | Object containing eigenvalues (Array or Matrix) and eigenvectors (2D Array/Matrix).


## Examples

```js
const H = [[5, 2.3], [2.3, 1]]
const ans = math.eigs(H) // returns {values: [E1,E2...sorted], vectors: [v1,v2.... corresponding vectors]}
const E = ans.values
const U = ans.vectors
const UTxHxU = math.multiply(math.transpose(U), H, U) // rotates H to the eigen-representation
E[0] == UTxHxU[0][0]  // returns true
```


## See also

[inv](inv.md)
